%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function test_lsm(iteration)
close all;

%%%% read original image %%%%%
M = imread('init.JPG');

X = rgb2gray(M);
% X = filter2(fspecial('average',3),X)/255; %mask filter
[X_row, X_col] = size(X);

%%%% make binary image %%%%%
for i=1:X_row
    for j=1:X_col
        if(X(i,j) < 125) 
            X(i,j) = 255;
        else
            X(i,j) = 0;
        end
    end
end
 
%%%% initialize the zero level set function
phi = zeros(size(X));

for i=80:430
    for j=75:450
        if(X(i,j) == 255)
            phi(i,j) = 1;
        end
    end
end

figure;
[C1 h1] = contour(phi, [0 0], 'r'); % original = 2007 nodes

%fin_C1 = int16(C1(:,[2:2007]));

%m = zeros(559,579);
%for i=1:2006
%     p = fin_C1(1,i); 
%     q = fin_C1(2,i);
%     m(p,q) = 1;
%end


M = imread('inter.JPG');

M = imresize(M, [559 579]);
X = rgb2gray(M);
[X_row, X_col] = size(X);

% %%%% make binary image %%%%%
for i=1:X_row
    for j=1:X_col
        if(X(i,j) < 105) 
            X(i,j) = 255;
        else
            X(i,j) = 0;
        end
    end
end

seg = chenvese(X,phi,iteration,10000,'chan');
figure;
[C2,h2] = contour(seg, [0 0], 'r');

index = 1;
for i=1:size(C2,2)
    x = C2(1,i); 
    y = C2(2,i); 
    
    if(y < 1000)
            intermediate(:, index) = C2(:,i);
            index = index + 1;
    end
end
% 
h = figure;
plot(intermediate(1,:), intermediate(2,:));

filename = ['init_to_inter_lsm_', num2str(iteration)];
fid = fopen(filename, 'w');
for i=1:size(intermediate, 2)
    fprintf(fid, '%f\t%f\n', intermediate(1,i), intermediate(2,i));
end
fclose(fid);

